@extends('layouts.app')
@section('title', 'Rack/Row/Position Details')

@section('content')
<div class="container">
    <h1>Rack/Row/Position Details</h1>
    
    {{-- Debug: show number of products --}}
    <p>Total products: {{ $products->count() }}</p>
    
    @if($products->isEmpty())
        <p>No products found for your business.</p>
    @else
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Product Name</th>
                    <th>Rack</th>
                    <th>Row</th>
                    <th>Position</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                @foreach($products as $product)
                    @php
                        // Assuming your Product model defines:
                        // public function rack_details() { return $this->hasMany(\App\ProductRack::class, 'product_id'); }
                        $rack = $product->rack_details->first();
                    @endphp
                    <tr>
                        <td>{{ $product->name }} ({{ $product->sku }})</td>
                        <td>{{ $rack ? $rack->rack : 'N/A' }}</td>
                        <td>{{ $rack ? $rack->row : 'N/A' }}</td>
                        <td>{{ $rack ? $rack->position : 'N/A' }}</td>
                        <td>
                            <button type="button" 
                                    class="btn btn-primary btn-xs edit-rack"
                                    data-product_id="{{ $product->id }}"
                                    data-location_id="{{ $rack ? $rack->location_id : '' }}"
                                    data-rack="{{ $rack ? $rack->rack : '' }}"
                                    data-row="{{ $rack ? $rack->row : '' }}"
                                    data-position="{{ $rack ? $rack->position : '' }}">
                                Edit
                            </button>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @endif
</div>

<!-- Modal for editing rack details -->
<div class="modal fade" id="rackModal" tabindex="-1" role="dialog" aria-labelledby="rackModalLabel">
    <div class="modal-dialog" role="document">
        <form method="POST" action="{{ route('products.rack_edit.update') }}">
            @csrf
            <input type="hidden" name="product_id" id="modal_product_id">
            <input type="hidden" name="location_id" id="modal_location_id">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="rackModalLabel">Edit Rack/Row/Position</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                      <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label>Rack</label>
                        <input type="text" name="rack" id="modal_rack" class="form-control">
                    </div>
                    <div class="form-group">
                        <label>Row</label>
                        <input type="text" name="row" id="modal_row" class="form-control">
                    </div>
                    <div class="form-group">
                        <label>Position</label>
                        <input type="text" name="position" id="modal_position" class="form-control">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Save changes</button>
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection

@section('javascript')
<script>
$(document).ready(function(){
    $('.edit-rack').on('click', function(e){
        e.preventDefault();
        var productId = $(this).data('product_id');
        var locationId = $(this).data('location_id');
        var rack = $(this).data('rack');
        var row = $(this).data('row');
        var position = $(this).data('position');

        $('#modal_product_id').val(productId);
        $('#modal_location_id').val(locationId);
        $('#modal_rack').val(rack);
        $('#modal_row').val(row);
        $('#modal_position').val(position);

        $('#rackModal').modal('show');
    });
});
</script>
@endsection
