@extends('layouts.app')
@section('title', __('lang_v1.add_serials'))

@section('content')
<section class="content-header">
    <h1>@lang('lang_v1.add_serials')</h1>
</section>

<section class="content">

    @if(session('status'))
        <div class="row">
            <div class="col-sm-12">
                @php
                    $status = session('status');
                @endphp
                @if(!empty($status['success']) && $status['success'] == 1)
                    <div class="alert alert-success">
                        {{ $status['msg'] }}
                    </div>
                @elseif(!empty($status['success']) && $status['success'] == 0)
                    <div class="alert alert-danger">
                        {{ $status['msg'] }}
                    </div>
                @endif
            </div>
        </div>
    @endif

    <div class="box box-primary">
        <div class="box-body">

            <!-- Minimal Purchase Info -->
            <div class="row">
                <div class="col-md-3">
                    <strong>@lang('purchase.purchase_date'): </strong> 
                    {{ @format_datetime($purchase->transaction_date) }}
                </div>
                <div class="col-md-3">
                    <strong>@lang('purchase.ref_no'): </strong> 
                    {{ $purchase->ref_no }}
                </div>
                <div class="col-md-3">
                    <strong>@lang('purchase.business_location'): </strong>
                    {{ optional($purchase->location)->name }}
                </div>
                <div class="col-md-3">
                    <strong>@lang('purchase.payment_status'): </strong> 
                    {{ $purchase->payment_status }}
                </div>
            </div>

            <hr>

            <!-- Form for saving serials -->
            <form action="{{ action([\App\Http\Controllers\PurchaseController::class, 'saveSerials'], [$purchase->id]) }}"
                  method="POST">
                @csrf

                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>@lang('product.product')</th>
                            <th>@lang('purchase.purchase_quantity')</th>
                            <th>@lang('lang_v1.add_new_serials')</th>
                            <th>@lang('lang_v1.existing_serial_numbers')</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($purchase->purchase_lines as $line)
                            <tr>
                                <td>
                                    {{ optional($line->product)->name }}
                                    @if(!empty($line->variations->name) && $line->variations->name != 'DUMMY')
                                        ({{ $line->variations->name }})
                                    @endif
                                </td>
                                <td>{{ $line->quantity }}</td>

                                <td>
                                    @php
                                        // Convert quantity to an integer for safety
                                        $qty = (int) $line->quantity;
                                    @endphp
                                    @for($i = 1; $i <= $qty; $i++)
                                        <div style="margin-bottom:5px;">
                                            <input type="text"
                                                   class="form-control"
                                                   name="serials[{{ $line->id }}][]"
                                                   placeholder="Serial #{{ $i }}">
                                        </div>
                                    @endfor
                                </td>

                                <td>
                                    @if($line->serialNumbers->count() > 0)
                                        <ul>
                                            @foreach($line->serialNumbers as $sn)
                                                <li>{{ $sn->serial_number }}</li>
                                            @endforeach
                                        </ul>
                                    @else
                                        @lang('lang_v1.none')
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>

                <div class="text-center">
                    <button type="submit" class="btn btn-primary">
                        @lang('messages.save')
                    </button>
                </div>
            </form>

        </div>
    </div>
</section>
@endsection
