@extends('layouts.app')
@section('title', __('product.add_new_product'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">
        @lang('product.add_new_product')
    </h1>
</section>

<!-- Main content -->
<section class="content">
    @php
        // In create view, there is no $product; if duplicating an existing product, use $duplicate_product.
        $form_class = empty($duplicate_product) ? 'create' : '';
        $is_image_required = !empty($common_settings['is_product_image_required']);
        // Ensure $sub_sub_categories is defined.
        $sub_sub_categories = $sub_sub_categories ?? [];

        // OPTIONAL: If duplicating and the duplicate product has a sub‑sub category, ensure it’s included.
        if (!empty($duplicate_product->sub_sub_category_id)) {
            if (empty($sub_sub_categories)) {
                $sub_sub_categories = [$duplicate_product->sub_sub_category_id => $duplicate_product->subSubCategory->name];
            } elseif (!array_key_exists($duplicate_product->sub_sub_category_id, $sub_sub_categories)) {
                $sub_sub_categories[$duplicate_product->sub_sub_category_id] = $duplicate_product->subSubCategory->name;
            }
        }
    @endphp

    {!! Form::open([
        'url' => action([\App\Http\Controllers\ProductController::class, 'store']),
        'method' => 'post',
        'id' => 'product_add_form',
        'class' => 'product_form ' . $form_class,
        'files' => true
    ]) !!}

    @component('components.widget', ['class' => 'box-primary'])
    <div class="row">
        <!-- Product Name -->
        <div class="col-sm-4">
            <div class="form-group">
                {!! Form::label('name', __('product.product_name') . ':*') !!}
                {!! Form::text('name', !empty($duplicate_product->name) ? $duplicate_product->name : null, [
                    'class' => 'form-control',
                    'required',
                    'placeholder' => __('product.product_name')
                ]) !!}
            </div>
        </div>

        <!-- SKU -->
        <div class="col-sm-4">
            <div class="form-group">
                {!! Form::label('sku', __('product.sku') . ':') !!}
                @show_tooltip(__('tooltip.sku'))
                {!! Form::text('sku', null, [
                    'class' => 'form-control',
                    'placeholder' => __('product.sku')
                ]) !!}
            </div>
        </div>

        <!-- Barcode Type -->
        <div class="col-sm-4">
            <div class="form-group">
                {!! Form::label('barcode_type', __('product.barcode_type') . ':*') !!}
                {!! Form::select('barcode_type', $barcode_types,
                    !empty($duplicate_product->barcode_type) ? $duplicate_product->barcode_type : $barcode_default,
                    ['class' => 'form-control select2', 'required']
                ) !!}
            </div>
        </div>

        <div class="clearfix"></div>

        <!-- Unit -->
        <div class="col-sm-4">
            <div class="form-group">
                {!! Form::label('unit_id', __('product.unit') . ':*') !!}
                <div class="input-group">
                    {!! Form::select('unit_id', $units,
                        !empty($duplicate_product->unit_id) ? $duplicate_product->unit_id : session('business.default_unit'),
                        ['class' => 'form-control select2', 'required']
                    ) !!}
                    <span class="input-group-btn">
                        <button type="button" @if(!auth()->user()->can('unit.create')) disabled @endif
                            class="btn btn-default bg-white btn-flat btn-modal"
                            data-href="{{ action([\App\Http\Controllers\UnitController::class, 'create'], ['quick_add' => true]) }}"
                            title="@lang('unit.add_unit')"
                            data-container=".view_modal">
                            <i class="fa fa-plus-circle text-primary fa-lg"></i>
                        </button>
                    </span>
                </div>
            </div>
        </div>

        <!-- Sub Units -->
        <div class="col-sm-4 @if(!session('business.enable_sub_units')) hide @endif">
            <div class="form-group">
                {!! Form::label('sub_unit_ids', __('lang_v1.related_sub_units') . ':') !!}
                @show_tooltip(__('lang_v1.sub_units_tooltip'))
                {!! Form::select('sub_unit_ids[]', [], !empty($duplicate_product->sub_unit_ids) ? $duplicate_product->sub_unit_ids : null,
                    ['class' => 'form-control select2', 'multiple', 'id' => 'sub_unit_ids']
                ) !!}
            </div>
        </div>

        <!-- Secondary Unit -->
        @if(!empty($common_settings['enable_secondary_unit']))
        <div class="col-sm-4">
            <div class="form-group">
                {!! Form::label('secondary_unit_id', __('lang_v1.secondary_unit') . ':') !!}
                @show_tooltip(__('lang_v1.secondary_unit_help'))
                {!! Form::select('secondary_unit_id', $units,
                    !empty($duplicate_product->secondary_unit_id) ? $duplicate_product->secondary_unit_id : null,
                    ['class' => 'form-control select2']
                ) !!}
            </div>
        </div>
        @endif

        <!-- Brand -->
        <div class="col-sm-4 @if(!session('business.enable_brand')) hide @endif">
            <div class="form-group">
                {!! Form::label('brand_id', __('product.brand') . ':') !!}
                <div class="input-group">
                    {!! Form::select('brand_id', $brands,
                        !empty($duplicate_product->brand_id) ? $duplicate_product->brand_id : null,
                        ['placeholder' => __('messages.please_select'), 'class' => 'form-control select2']
                    ) !!}
                    <span class="input-group-btn">
                        <button type="button" @if(!auth()->user()->can('brand.create')) disabled @endif
                            class="btn btn-default bg-white btn-flat btn-modal"
                            data-href="{{ action([\App\Http\Controllers\BrandController::class, 'create'], ['quick_add' => true]) }}"
                            title="@lang('brand.add_brand')"
                            data-container=".view_modal">
                            <i class="fa fa-plus-circle text-primary fa-lg"></i>
                        </button>
                    </span>
                </div>
            </div>
        </div>

        <!-- Category -->
        <div class="col-sm-4 @if(!session('business.enable_category')) hide @endif">
            <div class="form-group">
                {!! Form::label('category_id', __('product.category') . ':') !!}
                {!! Form::select('category_id', $categories,
                    !empty($duplicate_product->category_id) ? $duplicate_product->category_id : null,
                    ['placeholder' => __('messages.please_select'), 'class' => 'form-control select2']
                ) !!}
            </div>
        </div>

        <!-- Sub Category -->
        <div class="col-sm-4 @if(!(session('business.enable_category') && session('business.enable_sub_category'))) hide @endif">
            <div class="form-group">
                {!! Form::label('sub_category_id', __('product.sub_category') . ':') !!}
                {!! Form::select('sub_category_id', $sub_categories,
                    !empty($duplicate_product->sub_category_id) ? $duplicate_product->sub_category_id : null,
                    ['placeholder' => __('messages.please_select'), 'class' => 'form-control select2', 'id' => 'sub_category_id']
                ) !!}
            </div>
        </div>

        <!-- Sub Sub Category (Same design as Sub Category) -->
        <div class="col-sm-4 @if(!(session('business.enable_category') && session('business.enable_sub_category'))) hide @endif" id="sub_sub_category_div">
            <div class="form-group">
                {!! Form::label('sub_sub_category_id', __('product.sub_sub_category') . ':') !!}
                {!! Form::select('sub_sub_category_id', $sub_sub_categories,
                    !empty($duplicate_product->sub_sub_category_id) ? $duplicate_product->sub_sub_category_id : null,
                    ['placeholder' => __('messages.please_select'), 'class' => 'form-control select2', 'id' => 'sub_sub_category_id']
                ) !!}
            </div>
        </div>

        @php
            $default_location = (count($business_locations) == 1) ? array_key_first($business_locations->toArray()) : null;
        @endphp
        <!-- Business Locations -->
        <div class="col-sm-4">
            <div class="form-group">
                {!! Form::label('product_locations', __('business.business_locations') . ':') !!}
                @show_tooltip(__('lang_v1.product_location_help'))
                {!! Form::select('product_locations[]', $business_locations, $default_location,
                    ['class' => 'form-control select2', 'multiple', 'id' => 'product_locations']
                ) !!}
            </div>
        </div>

        <div class="clearfix"></div>

        <!-- Stock Management -->
        <div class="col-sm-4">
            <div class="form-group">
                <br>
                <label>
                    {!! Form::checkbox('enable_stock', 1, !empty($duplicate_product) ? $duplicate_product->enable_stock : true, ['class' => 'input-icheck', 'id' => 'enable_stock']) !!}
                    <strong>@lang('product.manage_stock')</strong>
                </label>
                @show_tooltip(__('tooltip.enable_stock'))
                <p class="help-block"><i>@lang('product.enable_stock_help')</i></p>
            </div>
        </div>

        <div class="col-sm-4 @if(!empty($duplicate_product) && $duplicate_product->enable_stock == 0) hide @endif" id="alert_quantity_div">
            <div class="form-group">
                {!! Form::label('alert_quantity', __('product.alert_quantity') . ':') !!}
                @show_tooltip(__('tooltip.alert_quantity'))
                {!! Form::text('alert_quantity', !empty($duplicate_product->alert_quantity) ? @format_quantity($duplicate_product->alert_quantity) : null, [
                    'class' => 'form-control input_number',
                    'placeholder' => __('product.alert_quantity'),
                    'min' => '0'
                ]) !!}
            </div>
        </div>

        <!-- Warranty -->
        @if(!empty($common_settings['enable_product_warranty']))
        <div class="col-sm-4">
            <div class="form-group">
                {!! Form::label('warranty_id', __('lang_v1.warranty') . ':') !!}
                {!! Form::select('warranty_id', $warranties, null, [
                    'class' => 'form-control select2',
                    'placeholder' => __('messages.please_select')
                ]) !!}
            </div>
        </div>
        @endif

        <!-- Include Module Fields -->
        @if(!empty($pos_module_data))
            @foreach($pos_module_data as $key => $value)
                @if(!empty($value['view_path']))
                    @includeIf($value['view_path'], ['view_data' => $value['view_data']])
                @endif
            @endforeach
        @endif

        <div class="clearfix"></div>

        <!-- Product Description -->
        <div class="col-sm-8">
            <div class="form-group">
                {!! Form::label('product_description', __('lang_v1.product_description') . ':') !!}
                {!! Form::textarea('product_description', !empty($duplicate_product->product_description) ? $duplicate_product->product_description : null, ['class' => 'form-control']) !!}
            </div>
        </div>

        <!-- Product Image -->
        <div class="col-sm-4">
            <div class="form-group">
                {!! Form::label('image', __('lang_v1.product_image') . ':') !!}
                {!! Form::file('image', [
                    'id' => 'upload_image',
                    'accept' => 'image/*',
                    'required' => $is_image_required,
                    'class' => 'upload-element'
                ]) !!}
                <small>
                    <p class="help-block">
                        @lang('purchase.max_file_size', ['size' => (config('constants.document_size_limit') / 1000000)]) <br>
                        @lang('lang_v1.aspect_ratio_should_be_1_1')
                    </p>
                </small>
            </div>
        </div>
    </div>
    @endcomponent

    <!-- Additional Product Details -->
    @component('components.widget', ['class' => 'box-primary'])
    <div class="row">
        @if(session('business.enable_product_expiry'))
            @if(session('business.expiry_type') == 'add_expiry')
                @php $expiry_period = 12; $hide = true; @endphp
            @else
                @php $expiry_period = null; $hide = false; @endphp
            @endif
            <div class="col-sm-4 @if($hide) hide @endif">
                <div class="form-group">
                    <div class="multi-input">
                        {!! Form::label('expiry_period', __('product.expires_in') . ':') !!}<br>
                        {!! Form::text('expiry_period', !empty($duplicate_product->expiry_period) ? @num_format($duplicate_product->expiry_period) : $expiry_period, [
                            'class' => 'form-control pull-left input_number',
                            'placeholder' => __('product.expiry_period'),
                            'style' => 'width:60%;'
                        ]) !!}
                        {!! Form::select('expiry_period_type', [
                                'months' => __('product.months'),
                                'days'   => __('product.days'),
                                ''       => __('product.not_applicable')
                            ],
                            !empty($duplicate_product->expiry_period_type) ? $duplicate_product->expiry_period_type : 'months',
                            ['class' => 'form-control select2 pull-left', 'style' => 'width:40%;', 'id' => 'expiry_period_type']
                        ) !!}
                    </div>
                </div>
            </div>
        @endif

        <!-- Enable SR No -->
        <div class="col-sm-4">
            <div class="form-group">
                <br>
                <label>
                    {!! Form::checkbox('enable_sr_no', 1, !empty($duplicate_product) ? $duplicate_product->enable_sr_no : false, ['class' => 'input-icheck']) !!}
                    <strong>@lang('lang_v1.enable_imei_or_sr_no')</strong>
                </label>
                @show_tooltip(__('lang_v1.tooltip_sr_no'))
            </div>
        </div>

        <!-- Not for Selling -->
        <div class="col-sm-4">
            <div class="form-group">
                <br>
                <label>
                    {!! Form::checkbox('not_for_selling', 1, !empty($duplicate_product) ? $duplicate_product->not_for_selling : false, ['class' => 'input-icheck']) !!}
                    <strong>@lang('lang_v1.not_for_selling')</strong>
                </label>
                @show_tooltip(__('lang_v1.tooltip_not_for_selling'))
            </div>
        </div>

        <div class="clearfix"></div>

        <!-- Rack Details -->
        @if(session('business.enable_racks') || session('business.enable_row') || session('business.enable_position'))
            <div class="col-md-12">
                <h4>@lang('lang_v1.rack_details'): @show_tooltip(__('lang_v1.tooltip_rack_details'))</h4>
            </div>
            @foreach($business_locations as $id => $location)
                <div class="col-sm-3">
                    <div class="form-group">
                        {!! Form::label('rack_' . $id, $location . ':') !!}
                        @if(session('business.enable_racks'))
                            {!! Form::text('product_racks[' . $id . '][rack]', !empty($rack_details[$id]['rack']) ? $rack_details[$id]['rack'] : null, ['class' => 'form-control', 'id' => 'rack_' . $id, 'placeholder' => __('lang_v1.rack')]) !!}
                        @endif
                        @if(session('business.enable_row'))
                            {!! Form::text('product_racks[' . $id . '][row]', !empty($rack_details[$id]['row']) ? $rack_details[$id]['row'] : null, ['class' => 'form-control', 'placeholder' => __('lang_v1.row')]) !!}
                        @endif
                        @if(session('business.enable_position'))
                            {!! Form::text('product_racks[' . $id . '][position]', !empty($rack_details[$id]['position']) ? $rack_details[$id]['position'] : null, ['class' => 'form-control', 'placeholder' => __('lang_v1.position')]) !!}
                        @endif
                    </div>
                </div>
            @endforeach
        @endif

        <div class="col-sm-4">
            <div class="form-group">
                {!! Form::label('weight', __('lang_v1.weight') . ':') !!}
                {!! Form::text('weight', !empty($duplicate_product->weight) ? $duplicate_product->weight : null, ['class' => 'form-control', 'placeholder' => __('lang_v1.weight')]) !!}
            </div>
        </div>

        @php
            $custom_labels = json_decode(session('business.custom_labels'), true);
            $product_custom_fields = !empty($custom_labels['product']) ? $custom_labels['product'] : [];
            $product_cf_details = !empty($custom_labels['product_cf_details']) ? $custom_labels['product_cf_details'] : [];
        @endphp

        <!-- Custom Fields -->
        <div class="clearfix"></div>
        @foreach($product_custom_fields as $index => $cf)
            @if(!empty($cf))
                @php
                    $db_field_name = 'product_custom_field' . $loop->iteration;
                    $cf_type = !empty($product_cf_details[$loop->iteration]['type']) ? $product_cf_details[$loop->iteration]['type'] : 'text';
                    $dropdown = !empty($product_cf_details[$loop->iteration]['dropdown_options']) ? explode(PHP_EOL, $product_cf_details[$loop->iteration]['dropdown_options']) : [];
                @endphp
                <div class="col-sm-3">
                    <div class="form-group">
                        {!! Form::label($db_field_name, $cf . ':') !!}
                        @if(in_array($cf_type, ['text', 'date']))
                            <input type="{{$cf_type}}" name="{{$db_field_name}}" id="{{$db_field_name}}"
                                value="{{ !empty($duplicate_product->$db_field_name) ? $duplicate_product->$db_field_name : null }}"
                                class="form-control" placeholder="{{$cf}}">
                        @elseif($cf_type == 'dropdown')
                            {!! Form::select($db_field_name, $dropdown, !empty($duplicate_product->$db_field_name) ? $duplicate_product->$db_field_name : null, ['placeholder' => $cf, 'class' => 'form-control select2']) !!}
                        @endif
                    </div>
                </div>
            @endif
        @endforeach

        <div class="col-sm-3">
            <div class="form-group">
                {!! Form::label('preparation_time_in_minutes', __('lang_v1.preparation_time_in_minutes') . ':') !!}
                {!! Form::number('preparation_time_in_minutes', !empty($duplicate_product->preparation_time_in_minutes) ? $duplicate_product->preparation_time_in_minutes : null, ['class' => 'form-control', 'placeholder' => __('lang_v1.preparation_time_in_minutes')]) !!}
            </div>
        </div>

        <!-- Include Module Form Parts -->
        <div class="clearfix"></div>
        @include('layouts.partials.module_form_part')
    </div>
    @endcomponent

    @component('components.widget', ['class' => 'box-primary'])
    <div class="row">
        <div class="col-sm-4 @if(!session('business.enable_price_tax')) hide @endif">
            <div class="form-group">
                {!! Form::label('tax', __('product.applicable_tax') . ':') !!}
                {!! Form::select('tax', $taxes, !empty($duplicate_product->tax) ? $duplicate_product->tax : null, [
                    'placeholder' => __('messages.please_select'),
                    'class' => 'form-control select2'
                ], $tax_attributes) !!}
            </div>
        </div>

        <div class="col-sm-4 @if(!session('business.enable_price_tax')) hide @endif">
            <div class="form-group">
                {!! Form::label('tax_type', __('product.selling_price_tax_type') . ':*') !!}
                {!! Form::select('tax_type', ['inclusive' => __('product.inclusive'), 'exclusive' => __('product.exclusive')],
                    !empty($duplicate_product->tax_type) ? $duplicate_product->tax_type : 'exclusive',
                    ['class' => 'form-control select2', 'required']
                ) !!}
            </div>
        </div>

        <div class="clearfix"></div>

        <div class="col-sm-4">
            <div class="form-group">
                {!! Form::label('type', __('product.product_type') . ':*') !!}
                @show_tooltip(__('tooltip.product_type'))
                {!! Form::select('type', $product_types,
                    !empty($duplicate_product->type) ? $duplicate_product->type : null,
                    ['class' => 'form-control select2',
                     'required',
                     'data-action' => !empty($duplicate_product) ? 'duplicate' : 'add',
                     'data-product_id' => !empty($duplicate_product) ? $duplicate_product->id : '0'
                    ]
                ) !!}
            </div>
        </div>

        <div class="form-group col-sm-12" id="product_form_part">
            @include('product.partials.single_product_form_part', ['profit_percent' => $default_profit_percent])
        </div>

        <input type="hidden" id="variation_counter" value="1">
        <input type="hidden" id="default_profit_percent" value="{{ $default_profit_percent }}">
    </div>
    @endcomponent

    <div class="row">
        <div class="col-sm-12">
            <input type="hidden" name="submit_type" id="submit_type">
            <div class="text-center">
                <div class="btn-group">
                    @if($selling_price_group_count)
                        <button type="submit" value="submit_n_add_selling_prices" class="btn btn-warning btn-big submit_product_form">
                            @lang('lang_v1.save_n_add_selling_price_group_prices')
                        </button>
                    @endif
                    @can('product.opening_stock')
                        <button id="opening_stock_button" @if(!empty($duplicate_product) && $duplicate_product->enable_stock == 0) disabled @endif
                            type="submit" value="submit_n_add_opening_stock" class="btn bg-purple btn-big submit_product_form">
                            @lang('lang_v1.save_n_add_opening_stock')
                        </button>
                    @endcan
                    <button type="submit" value="save_n_add_another" class="btn bg-maroon btn-big submit_product_form">
                        @lang('lang_v1.save_n_add_another')
                    </button>
                    <button type="submit" value="submit" class="btn btn-primary btn-big submit_product_form">
                        @lang('messages.save')
                    </button>
                </div>
            </div>
        </div>
    </div>
    
    {!! Form::close() !!}
</section>
<!-- /.content -->

@endsection

@section('javascript')
<script src="{{ asset('js/product.js?v=' . $asset_v) }}"></script>
<script type="text/javascript">
    $(document).ready(function() {
        __page_leave_confirmation('#product_add_form');
        onScan.attachTo(document, {
            suffixKeyCodes: [13],
            reactToPaste: true,
            onScan: function(sCode, iQty) {
                $('input#sku').val(sCode);
            },
            onScanError: function(oDebug) {
                console.log(oDebug);
            },
            minLength: 2,
            ignoreIfFocusOn: ['input', '.form-control']
        });
        
        // Listen for changes on the Sub-Category select to load Sub-Sub Categories.
        $('select[name="sub_category_id"]').on('change', function() {
            var sub_cat_id = $(this).val();
            if (sub_cat_id) {
                $.ajax({
                    method: "POST",
                    url: "{{ action([\App\Http\Controllers\ProductController::class, 'getSubSubCategories']) }}",
                    data: { sub_cat_id: sub_cat_id, _token: "{{ csrf_token() }}" },
                    success: function(result) {
                        if($.trim(result) !== '' && result.indexOf('<option') !== -1) {
                            // Show the sub_sub_category field and populate options.
                            $('#sub_sub_category_div').show();
                            $('select[name="sub_sub_category_id"]').html(result);
                        } else {
                            // Even if no options returned, clear the list but leave the field visible.
                            $('select[name="sub_sub_category_id"]').html('<option value="">{{ __("messages.please_select") }}</option>');
                        }
                    },
                    error: function(xhr, status, error) {
                        console.error('Error fetching sub sub categories:', error);
                    }
                });
            } else {
                // No sub category selected; simply clear the sub sub category options.
                $('select[name="sub_sub_category_id"]').html('<option value="">{{ __("messages.please_select") }}</option>');
            }
        });
    });
</script>
@endsection
