<div class="modal-dialog" role="document">
  <div class="modal-content">

    {!! Form::open(['url' => action([\App\Http\Controllers\TaxonomyController::class, 'store']), 'method' => 'post', 'id' => 'category_add_form' ]) !!}
    <div class="modal-header">
      <button type="button" class="close" data-dismiss="modal" aria-label="Close">
         <span aria-hidden="true">&times;</span>
      </button>
      <h4 class="modal-title">@lang( 'messages.add' )</h4>
    </div>

    <div class="modal-body">
      <input type="hidden" name="category_type" value="{{$category_type}}">
      @php
        $name_label = !empty($module_category_data['taxonomy_label']) ? $module_category_data['taxonomy_label'] : __( 'category.category_name' );
        $cat_code_enabled = isset($module_category_data['enable_taxonomy_code']) && !$module_category_data['enable_taxonomy_code'] ? false : true;
        $cat_code_label = !empty($module_category_data['taxonomy_code_label']) ? $module_category_data['taxonomy_code_label'] : __( 'category.code' );
        $enable_sub_category = isset($module_category_data['enable_sub_taxonomy']) && !$module_category_data['enable_sub_taxonomy'] ? false : true;
        $category_code_help_text = !empty($module_category_data['taxonomy_code_help_text']) ? $module_category_data['taxonomy_code_help_text'] : __('lang_v1.category_code_help');
      @endphp
      <div class="form-group">
        {!! Form::label('name', $name_label . ':*') !!}
        {!! Form::text('name', null, ['class' => 'form-control', 'required', 'placeholder' => $name_label]); !!}
      </div>
      @if($cat_code_enabled)
      <div class="form-group">
        {!! Form::label('short_code', $cat_code_label . ':') !!}
        {!! Form::text('short_code', null, ['class' => 'form-control', 'placeholder' => $cat_code_label]); !!}
        <p class="help-block">{!! $category_code_help_text !!}</p>
      </div>
      @endif
      <div class="form-group">
        {!! Form::label('description', __( 'lang_v1.description' ) . ':') !!}
        {!! Form::textarea('description', null, ['class' => 'form-control', 'placeholder' => __( 'lang_v1.description'), 'rows' => 3]); !!}
      </div>
      @if(!empty($parent_categories) && $enable_sub_category)
        <!-- Toggle for adding a sub taxonomy -->
        <div class="form-group">
            <div class="checkbox">
              <label>
                {!! Form::checkbox('add_as_sub_cat', 1, false, [ 'class' => 'toggler', 'data-toggle_id' => 'parent_cat_div' ]); !!}
                @lang( 'lang_v1.add_as_sub_txonomy' )
              </label>
            </div>
        </div>
        <div class="form-group hide" id="parent_cat_div">
          {!! Form::label('parent_id', __( 'category.select_parent_category' ) . ':') !!}
          {!! Form::select('parent_id', $parent_categories, null, ['class' => 'form-control']); !!}
        </div>
        <!-- Toggle for adding a sub-sub taxonomy -->
        <div class="form-group">
            <div class="checkbox">
              <label>
                {!! Form::checkbox('add_as_sub_sub_cat', 1, false, [ 'class' => 'toggler', 'data-toggle_id' => 'sub_parent_div' ]); !!}
                @lang( 'lang_v1.add_as_sub_sub_txonomy' )
              </label>
            </div>
        </div>
        <div class="form-group hide" id="sub_parent_div">
          {!! Form::label('sub_parent_id', __( 'category.select_sub_parent_category' ) . ':') !!}
          {!! Form::select('sub_parent_id', [], null, ['class' => 'form-control']); !!}
        </div>
      @endif
    </div>

    <div class="modal-footer">
      <button type="submit" class="btn btn-primary">@lang( 'messages.save' )</button>
      <button type="button" class="btn btn-default" data-dismiss="modal">@lang( 'messages.close' )</button>
    </div>

    {!! Form::close() !!}

  </div><!-- /.modal-content -->
</div><!-- /.modal-dialog -->

{{-- JavaScript Section to load sub-sub category options --}}
@section('javascript')
<script type="text/javascript">
  $(document).ready(function() {
    // Toggle the sub category div when checkbox is toggled
    $('.toggler').click(function(){
      var toggleDiv = $(this).data('toggle_id');
      $('#' + toggleDiv).toggleClass('hide');
    });

    // When the parent category is changed and "add_as_sub_sub_cat" is checked,
    // load sub-categories for that parent category
    $('select[name="parent_id"]').on('change', function() {
      var parent_id = $(this).val();
      // Check if the "add as sub sub taxonomy" checkbox is checked
      if (parent_id && $('input[name="add_as_sub_sub_cat"]').is(':checked')) {
          $.ajax({
              method: "POST",
              url: "{{ action([\App\Http\Controllers\TaxonomyController::class, 'getSubCategories']) }}",
              data: { parent_id: parent_id, _token: "{{ csrf_token() }}" },
              success: function(result) {
                  if($.trim(result) !== '' && result.indexOf('<option') !== -1) {
                      $('#sub_parent_div').removeClass('hide');
                      $('select[name="sub_parent_id"]').html(result);
                  } else {
                      $('#sub_parent_div').addClass('hide');
                      $('select[name="sub_parent_id"]').html('');
                  }
              }
          });
      } else {
          $('#sub_parent_div').addClass('hide');
          $('select[name="sub_parent_id"]').html('');
      }
    });

    // Additionally, if the "add as sub sub taxonomy" checkbox is toggled,
    // attempt to load sub-categories if a parent is already selected.
    $('input[name="add_as_sub_sub_cat"]').on('change', function() {
      var parent_id = $('select[name="parent_id"]').val();
      if ($(this).is(':checked') && parent_id) {
          $.ajax({
              method: "POST",
              url: "{{ action([\App\Http\Controllers\TaxonomyController::class, 'getSubCategories']) }}",
              data: { parent_id: parent_id, _token: "{{ csrf_token() }}" },
              success: function(result) {
                  if($.trim(result) !== '' && result.indexOf('<option') !== -1) {
                      $('#sub_parent_div').removeClass('hide');
                      $('select[name="sub_parent_id"]').html(result);
                  } else {
                      $('#sub_parent_div').addClass('hide');
                      $('select[name="sub_parent_id"]').html('');
                  }
              }
          });
      } else {
          $('#sub_parent_div').addClass('hide');
          $('select[name="sub_parent_id"]').html('');
      }
    });
  });
</script>
@endsection
