<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('serial_numbers', function (Blueprint $table) {
            $table->bigIncrements('id');
            // Change purchase_line_id from unsignedBigInteger to unsignedInteger
            // to match the data type of purchase_lines.id (if defined using increments)
            $table->unsignedInteger('purchase_line_id');
            $table->unsignedBigInteger('product_id');
            $table->unsignedBigInteger('variation_id')->nullable();
            $table->string('serial_number');
            $table->timestamps();

            // Prevent duplicate serials for the same product/variation:
            $table->unique(['product_id', 'variation_id', 'serial_number']);

            // Set foreign keys if desired:
            $table->foreign('purchase_line_id')
                  ->references('id')
                  ->on('purchase_lines')
                  ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('serial_numbers');
    }
};
